%------------------------------------------------------------------------------
% File     : SYO932^10 : TPTP v9.2.0. Bugfixed v5.0.0.
% Domain   : Logical Calculi (Modal logic)
% Problem  : The converse Barcan formula is valid in quantified modal logic K
% Version  : [Ben10] axioms.
% English  : 

% Refs     : [Ben10a] Benzmueller (2010), Email to Geoff Sutcliffe
%          : [Ben10b] Benzmueller (2010), Simple Type Theory as a Framework
% Source   : [Ben10a]
% Names    : Problem 33 [Ben10b]

% Status   : Theorem
% Rating   : 0.11 v9.1.0, 0.12 v9.0.0, 0.10 v8.2.0, 0.23 v8.1.0, 0.18 v7.5.0, 0.14 v7.4.0, 0.11 v7.2.0, 0.00 v7.1.0, 0.25 v7.0.0, 0.14 v6.4.0, 0.17 v6.3.0, 0.20 v6.2.0, 0.14 v5.5.0, 0.17 v5.4.0, 0.20 v5.3.0, 0.40 v5.2.0, 0.20 v5.0.0
% Syntax   : Number of formulae    :   66 (  31 unt;  34 typ;  31 def)
%            Number of atoms       :  102 (  36 equ;   0 cnn)
%            Maximal formula atoms :   10 (   3 avg)
%            Number of connectives :  134 (   4   ~;   4   |;   8   &; 110   @)
%                                         (   0 <=>;   8  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    8 (   1 avg)
%            Number of types       :    3 (   1 usr)
%            Number of type conns  :  172 ( 172   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   39 (  37 usr;   5 con; 0-3 aty)
%            Number of variables   :   86 (  51   ^;  29   !;   6   ?;  86   :)
% SPC      : TH0_THM_EQU_NAR

% Comments : 
% Bugfixes : v5.0.0 - Bugfix to LCL013^0.ax
%------------------------------------------------------------------------------
%----Include the definitions for quantified multimodal logic
include('Axioms/LCL013^0.ax').
%------------------------------------------------------------------------------
%----Provide a constant for accesibility relation r
thf(r,type,
    r: $i > $i > $o ).

thf(p,type,
    p: mu > $i > $o ).

thf(ex2b,conjecture,
    ( mvalid
    @ ( mimplies
      @ ( mbox @ r
        @ ( mforall_ind
          @ ^ [X: mu] : ( p @ X ) ) )
      @ ( mforall_ind
        @ ^ [X: mu] : ( mbox @ r @ ( p @ X ) ) ) ) ) ).

%------------------------------------------------------------------------------
